package gov.va.vamf.scheduling.communitycare.service;

import com.agilex.healthcare.veteranappointment.datalayer.patient.NotificationPreferenceDao;
import com.agilex.healthcare.veteranappointment.datalayer.patient.NotificationPreferencePo;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import gov.va.vamf.scheduling.communitycare.datalayer.CCBookedAppointmentsRepository;
import gov.va.vamf.scheduling.communitycare.datalayer.CCTypeOfCaresRepository;
import gov.va.vamf.scheduling.communitycare.domain.BookedCCAppointment;
import gov.va.vamf.scheduling.communitycare.domain.CCTypeOfCare;
import gov.va.vamf.scheduling.direct.datalayer.appointment.PatientIdentifiersDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.ArrayList;
import java.util.List;

@Service
public class CCService {

	@Autowired
	private CCTypeOfCaresRepository ccTypeOfCaresRepository;

	@Autowired
	private CCBookedAppointmentsRepository ccBookedAppointmentsRepository;

	@Resource
	private PatientIdentifiersDataService patientIdentifiersDataService;

	@Resource
	private NotificationPreferenceDao notificationPreferenceDao;

	//# of days ahead to query
	//increased from 7 to 8 to include appointments that are technically 7 days from now but saved as 8 days from today because of UTC adjustment.
	private final int EARLIEST_APPOINTMENT_REMINDER = 8;

	public List<CCTypeOfCare> fetchAllCCTypeOfCaresFromMongo() {
		return ccTypeOfCaresRepository.findAll();
	}

	public CCTypeOfCare saveCCTypeOfCareToMongo(CCTypeOfCare ccTypeOfCare) {
		return ccTypeOfCaresRepository.save(ccTypeOfCare);
	}

	public Iterable<BookedCCAppointment> fetchCCBookedAppointmentsByPatientId(PatientIdentifier patientIdentifier) {
		PatientIdentifiers edipiIcnIdentifiers = patientIdentifiersDataService.getCorrespondIdentifiers(patientIdentifier);
		edipiIcnIdentifiers = patientIdentifiersDataService.filterForEdipiAndIcn(edipiIcnIdentifiers);
		ArrayList<String> ids = new ArrayList<>(edipiIcnIdentifiers.size());
		for(PatientIdentifier patientIdentifierItem: edipiIcnIdentifiers) {
			ids.add(patientIdentifierItem.getUniqueId());
		}

		return ccBookedAppointmentsRepository.findByPatientIdentifierUniqueIdIn(ids);
	}

	public List<BookedCCAppointment> findUpComingAppointments() {
		Calendar calendar = Calendar.getInstance();
		Date today = calendar.getTime();
		calendar.add(Calendar.DAY_OF_YEAR, EARLIEST_APPOINTMENT_REMINDER);
		Date aWeekFromToday = calendar.getTime();
		return ccBookedAppointmentsRepository.findByAppointmentTimeBetween(today, aWeekFromToday);
	}


	public VARPatientPreference fetchPatientPreference(String uniqueId ){
		NotificationPreferencePo notificationPreference = notificationPreferenceDao.get(uniqueId);
		VARPatientPreference preference = notificationPreference.create();
		return preference;
	}

}
